package worker

import (
	"container/ring"
	"sync"
	"time"
)

const (
	TaskStatusScheduled = "scheduled"
	TaskStatusStarted   = "started"
	TaskStatusCompleted = "completed"
	TaskStatusKilled    = "killed"
)

type LogItem struct {
	CID    string
	Time   time.Time
	Status string
}

type Log struct {
	ring *ring.Ring
	mu   sync.RWMutex
}

func NewLog() *Log {
	return &Log{
		ring: ring.New(1024),
	}
}

func (l *Log) Items() []LogItem {
	l.mu.RLock()
	defer l.mu.RUnlock()

	out := make([]LogItem, 0, l.ring.Len())
	l.ring.Do(func(i interface{}) {
		if i == nil {
			return
		}

		out = append(out, i.(LogItem))
	})

	for i, j := 0, len(out)-1; i < j; i, j = i+1, j-1 {
		out[i], out[j] = out[j], out[i]
	}
	return out
}

func (l *Log) Log(cid, status string) {
	l.mu.Lock()
	defer l.mu.Unlock()

	l.ring.Value = LogItem{
		CID:    cid,
		Time:   time.Now(),
		Status: status,
	}

	l.ring = l.ring.Next()
}
