package worker

import (
	"time"

	"github.com/go-rod/rod"
	"github.com/go-rod/rod/lib/proto"
	"github.com/hashicorp/go-uuid"
)

type Task interface {
	id() string
	do(*rod.Browser) error
}

type BaseTask struct {
	CID string `json:"-"`
}

type TaskNavigate struct {
	BaseTask
	URL     string                 `json:"url"`
	Cookies []*proto.NetworkCookie `json:"cookies"`
}

func (t *TaskNavigate) id() string {
	return t.CID
}

func (t *TaskNavigate) do(browser *rod.Browser) error {
	return rod.Try(func() {
		if len(t.Cookies) > 0 {
			browser.MustSetCookies(t.Cookies...)
		}

		page := browser.MustPage("")
		page.GetContext()
		wait := page.MustWaitNavigation()
		page.MustNavigate(t.URL)
		wait()

		time.Sleep(5 * time.Second)
		page.MustClose()
	})
}

func GenCID() (string, error) {
	return uuid.GenerateUUID()
}
