package main

import (
	"bytes"
	"crypto/sha256"
	"encoding/base64"
	"encoding/hex"
	"encoding/json"
	"io/ioutil"
	"log"

	"a.yandex-team.ru/security/tools/commongen/internal/maker"
)

func main() {
	config, err := ioutil.ReadFile("config.json")
	if err != nil {
		log.Fatal(err)
	}

	slugToSecrets := make(map[string][]byte)
	encConfig, initKey, err := maker.MakeSecrets(config, slugToSecrets)
	if err != nil {
		log.Fatal(err)
	}

	for slug, secret := range slugToSecrets {
		hash := sha256.Sum256(secret)
		log.Println(slug, hex.EncodeToString(hash[:]))
	}

	log.Println("===")
	log.Println("WARNING! The logs are further very sensitive, please do not keep them on yav.yandex-team.ru or on an unencrypted disk.")
	log.Println("===")

	str, err := json.Marshal(slugToSecrets)
	if err != nil {
		log.Fatal(err)
	}

	var baseBuf bytes.Buffer
	encoder := base64.NewEncoder(base64.StdEncoding, &baseBuf)
	_, err = encoder.Write([]byte(str))
	if err != nil {
		log.Fatal(err)
	}
	err = encoder.Close()
	if err != nil {
		log.Fatal(err)
	}

	log.Println("plaintext secrets in base64:", baseBuf.String())
	log.Printf("init key in hex: %s", hex.EncodeToString(initKey))
	err = ioutil.WriteFile("config.enc", encConfig, 0644)
	if err != nil {
		log.Fatal(err)
	}
	log.Println("was written to config.enc")
}
