package commands

import (
	"archive/tar"
	"compress/gzip"
	"fmt"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/tools/ctr/internal/compression"
	"a.yandex-team.ru/security/tools/ctr/internal/encrypt"
)

var encryptCmd = &cobra.Command{
	Use:          "encrypt [flags] [/path/to/dir]",
	SilenceUsage: true,
	Short:        "encrypt directory",
	RunE: func(_ *cobra.Command, args []string) error {
		targets := []string{"."}
		if len(args) > 0 {
			targets = args
		}

		f, err := os.OpenFile(arcPath, os.O_CREATE|os.O_WRONLY|os.O_TRUNC, 0644)
		if err != nil {
			return fmt.Errorf("can't create output file: %w", err)
		}
		defer func() { _ = f.Close() }()

		out, err := encrypt.NewWriter(f, getKey())
		if err != nil {
			return fmt.Errorf("can't create encrypted writer: %w", err)
		}
		defer func() { _ = out.Close() }()

		gzw := gzip.NewWriter(out)
		defer func() { _ = gzw.Close() }()

		tw := tar.NewWriter(gzw)
		defer func() { _ = tw.Close() }()

		for _, target := range targets {
			err = compression.CompressTo(target, tw, arcPath)
			if err != nil {
				return fmt.Errorf("compression failed: %w", err)
			}
		}

		return nil
	},
}

func init() {
	flags := encryptCmd.PersistentFlags()
	flags.StringVar(&arcPath, "archive", arcPath, "archive output")
	rootCmd.AddCommand(encryptCmd)
}
