package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/tools/ctr/internal/encrypt"
)

var newKeyCmd = &cobra.Command{
	Use:          "key",
	SilenceUsage: true,
	Short:        "generate new key",
	RunE: func(_ *cobra.Command, args []string) error {
		key, err := encrypt.NewKey()
		if err != nil {
			return fmt.Errorf("can't generate new key: %w", err)
		}

		fmt.Print(key)
		return nil
	},
}

func init() {
	rootCmd.AddCommand(newKeyCmd)
}
