package commands

import (
	"fmt"
	"io/ioutil"
	"os"

	"github.com/spf13/cobra"
)

var (
	encKeyPath string
	arcPath    = "app.tar.gz.enc"
)

var rootCmd = &cobra.Command{
	Use:          "ctr",
	SilenceUsage: true,
	Short:        "CTF Task Runner",
}

func Execute() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}

func init() {
	flags := rootCmd.PersistentFlags()
	flags.StringVar(&encKeyPath, "key-file", "", "path to file with key")
}

func getKey() string {
	if encKeyPath != "" {
		data, err := ioutil.ReadFile(encKeyPath)
		if err != nil {
			panic(fmt.Sprintf("can't read key file: %v", err))
		}
		return string(data)
	}
	return os.Getenv("CTR_KEY")
}
