package commands

import (
	"errors"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/tools/ctr/internal/starter"
)

var startArgs = struct {
	root    string
	logDir  string
	appName string
}{
	root:    ".",
	logDir:  "/run/ctr",
	appName: "app",
}

var startCmd = &cobra.Command{
	Use:          "start [flags] -- /child --child-flag1 --child-flagN",
	SilenceUsage: true,
	Short:        "start app from encrypted archive",
	RunE: func(cmd *cobra.Command, args []string) error {
		if len(args) <= 0 {
			return errors.New("no child commands provided")
		}

		if err := doDecrypt(startArgs.root); err != nil {
			return err
		}

		env := starter.Env{
			Command: args[0],
			LogDir:  startArgs.logDir,
			AppName: startArgs.appName,
		}
		if len(args) > 1 {
			env.Args = args[1:]
		}

		_, err := starter.Start(env)
		return err
	},
}

func init() {
	flags := startCmd.PersistentFlags()
	flags.StringVar(&startArgs.root, "root", startArgs.root, "root to unpack")
	flags.StringVar(&startArgs.logDir, "log-dir", startArgs.logDir, "log dir")
	flags.StringVar(&startArgs.appName, "app", startArgs.appName, "name of the running application")
	flags.StringVar(&arcPath, "archive", arcPath, "input archive")
	rootCmd.AddCommand(startCmd)
}
