package encrypt

import (
	"fmt"
	"io"

	"github.com/google/tink/go/streamingaead"
)

func NewReader(src io.Reader, key string) (io.Reader, error) {
	kh, err := ReadKey(key)
	if err != nil {
		return nil, err
	}

	a, err := streamingaead.New(kh)
	if err != nil {
		return nil, fmt.Errorf("can't create streaming AEAD: %w", err)
	}

	return a.NewDecryptingReader(src, nil)
}
