package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/tools/dizzy/internal/config"
	"a.yandex-team.ru/security/tools/dizzy/internal/oauth"
	"a.yandex-team.ru/security/tools/dizzy/internal/sshkey"
	"a.yandex-team.ru/security/tools/dizzy/internal/staff"
)

var oauthCmd = &cobra.Command{
	Use:   "oauth [flags] /ssh/key/path",
	Short: "Exchange the SSH key for OAuth token",
	RunE:  runOauthCmd,
}

var login string

func init() {
	oauthCmd.Flags().StringVar(&login, "login", "",
		"user login")

	RootCmd.AddCommand(oauthCmd)
}

func runOauthCmd(cmd *cobra.Command, args []string) error {
	var logins []string
	if login != "" {
		logins = make([]string, 1)
		logins[0] = login
	} else {
		fingerprint, err := sshkey.Fingerptint(config.SSHKey)
		if err != nil {
			return err
		}

		fmt.Printf("SSHKey fingerprint: %s\n", fingerprint)
		logins, err = staff.LoginsByKey(fingerprint)
		if err != nil {
			return err
		}

		if len(logins) == 0 {
			fmt.Println("SSH key not used by anyone")
			return nil
		}
	}

	for _, login := range logins {
		token, err := oauth.GetToken(config.SSHKey, login)
		if err != nil {
			simplelog.Warn("Failed to get OAuth token", "login", login, "err", err.Error())
		} else {
			fmt.Printf("%s: %s\n", login, token)
		}
	}
	return nil
}
