package commands

import (
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/tools/dizzy/internal/config"
	"a.yandex-team.ru/security/tools/dizzy/internal/sshkey"
	"a.yandex-team.ru/security/tools/dizzy/internal/staff"
)

var staffCmd = &cobra.Command{
	Use:   "staff [flags] /ssh/key/path",
	Short: "list staff users with provided SSH keys",
	RunE:  runStaffCmd,
}

func init() {
	RootCmd.AddCommand(staffCmd)
}

func runStaffCmd(cmd *cobra.Command, args []string) error {
	fingerprint, err := sshkey.Fingerptint(config.SSHKey)
	if err != nil {
		return err
	}

	fmt.Printf("SSHKey fingerprint: %s\n", fingerprint)
	logins, err := staff.LoginsByKey(fingerprint)
	if err != nil {
		return err
	}

	if len(logins) == 0 {
		fmt.Println("SSH key not used by anyone")
		return nil
	}

	fmt.Println("Staff users that uses this SSH key:")
	for _, l := range logins {
		fmt.Printf("\t%s\n", l)
	}
	return nil
}
