package conductor

import (
	"bufio"
	"strings"

	"a.yandex-team.ru/security/libs/go/yahttp"
)

func HostsByGroup(group string) (res []string, err error) {
	resp, err := yahttp.Get("https://c.yandex-team.ru/api/groups2hosts/" + group)
	if err != nil {
		return
	}
	defer yahttp.GracefulClose(resp.Body)

	scanner := bufio.NewScanner(resp.Body)
	res = make([]string, 0)
	for scanner.Scan() {
		host := scanner.Text()
		if strings.Contains(host, "Found 0 groups") {
			continue
		}

		res = append(res, host)
	}
	return
}
