package idm

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"

	"a.yandex-team.ru/security/libs/go/yahttp"
	"a.yandex-team.ru/security/tools/dizzy/internal/config"
)

type Role struct {
	System      string
	Description string
	Node        map[string]string
}

func RolesByLogin(login string, system string) (result []Role, resultErr error) {
	params := url.Values{
		"format": {"json"},
		"type":   {"active"},
		"limit":  {"50"},
		"user":   {login},
		"system": {system},
	}

	nextURL := "/api/v1/roles/?" + params.Encode()
	for len(nextURL) > 0 {
		func() {
			req, err := http.NewRequest("GET", "https://idm-api.yandex-team.ru"+nextURL, nil)
			if err != nil {
				resultErr = err
				return
			}

			req.Header.Set("Authorization", fmt.Sprintf("OAuth %s", config.OAuthToken))
			resp, err := yahttp.DoRequest(req)
			if err != nil {
				resultErr = err
				return
			}
			defer yahttp.GracefulClose(resp.Body)

			if resp.StatusCode != 200 {
				bb, _ := ioutil.ReadAll(resp.Body)
				resultErr = fmt.Errorf("failed to bring IDM API (%d): %s", resp.StatusCode, string(bb))
				return
			}

			var response struct {
				Meta struct {
					Next string `json:"next,omitempty"`
				}
				Objects []struct {
					HumanShort string `json:"human_short"`
					System     struct {
						Slug string
					}
					Node struct {
						Data map[string]string
					}
				}
			}

			err = json.NewDecoder(resp.Body).Decode(&response)
			if err != nil {
				resultErr = err
				return
			}
			nextURL = response.Meta.Next

			for _, o := range response.Objects {
				result = append(result, Role{
					System:      o.System.Slug,
					Description: o.HumanShort,
					Node:        o.Node.Data,
				})
			}
		}()
	}

	return
}
