package staff

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"

	"a.yandex-team.ru/security/libs/go/yahttp"
	"a.yandex-team.ru/security/tools/dizzy/internal/config"
)

func LoginsByKey(fingerprint string) (res []string, err error) {
	// https://staff-api.yandex-team.ru/v3/persons?_fields=login&_pretty=1&keys.fingerprint=7b:b8:e7:e5:29:3c:4b:a7:06:b9:b6:4d:b1:63:41:78
	params := url.Values{
		"is_deleted":       {"false"},
		"_fields":          {"login"},
		"keys.fingerprint": {fingerprint},
	}

	req, err := http.NewRequest("GET", "https://staff-api.yandex-team.ru/v3/persons?"+params.Encode(), nil)
	if err != nil {
		return
	}

	req.Header.Set("Authorization", fmt.Sprintf("OAuth %s", config.OAuthToken))
	resp, err := yahttp.DoRequest(req)
	if err != nil {
		return
	}
	defer yahttp.GracefulClose(resp.Body)

	if resp.StatusCode != 200 {
		bb, _ := ioutil.ReadAll(resp.Body)
		err = fmt.Errorf("failed to bring Staff API (%d): %s", resp.StatusCode, string(bb))
		return
	}

	var response struct {
		Result []struct {
			Login string
		}
	}

	err = json.NewDecoder(resp.Body).Decode(&response)
	if err != nil {
		return
	}

	res = make([]string, len(response.Result))
	for i, l := range response.Result {
		res[i] = l.Login
	}
	return

}
