package utils

import (
	"fmt"
	"math/rand"
)

var letters = []rune("abcdefghijklmnopqrstuvwxyz123456789")

func randSeq(n int) string {
	b := make([]rune, n)
	for i := range b {
		b[i] = letters[rand.Intn(len(letters))]
	}
	return string(b)
}

func RandHost() string {
	return randSeq(16)
}

func RandMac() string {
	buf := make([]byte, 6)
	_, err := rand.Read(buf)
	if err != nil {
		return "488EDF80577E"
	}
	buf[0] |= 2

	res := ""
	for _, b := range buf {
		res += fmt.Sprintf("%02x", b)
	}
	return res
}
