package commands

import (
	"log"
	"os"
	"os/exec"
	"strings"

	"github.com/spf13/cobra"
)

var benchWrapperCmd = &cobra.Command{
	Use:    "bench-wrapper [flags] -- [run_go_test]",
	Short:  "Run go bench binary",
	Hidden: true,
	RunE: func(_ *cobra.Command, args []string) error {
		var benchArgs []string
		haveBenchArg := false
		runGoTestArgsPos := 0
		for i, arg := range args {
			if arg == "--run_go_test" {
				runGoTestArgsPos = i + 1
				break
			}

			if strings.HasPrefix(arg, "-") && !strings.Contains(arg, "-test.") {
				arg = "-test." + strings.Trim(arg, "-")
			}

			if strings.HasPrefix(arg, "-test.bench=") || strings.HasSuffix(arg, "-test.bench") {
				haveBenchArg = true
			}
			benchArgs = append(benchArgs, arg)
		}

		if !haveBenchArg {
			benchArgs = append(benchArgs, "-test.bench=.")
		}

		var benchPath string
		for i := runGoTestArgsPos; i < len(args); i++ {
			if args[i] == "--binary" {
				benchPath = args[i+1]
				break
			}
		}

		if benchPath == "" {
			log.Println("no test binary to run")
			return nil
		}

		log.Printf("running: %s %s\n", benchPath, strings.Join(benchArgs, " "))
		yaMakeCmd := exec.Command(benchPath, benchArgs...)
		yaMakeCmd.Stdout = os.Stderr
		yaMakeCmd.Stderr = os.Stderr

		return yaMakeCmd.Run()
	},
}

func init() {
	RootCmd.AddCommand(benchWrapperCmd)
}
