package commands

import (
	"fmt"
	"os"
	"os/exec"
	"strings"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/libs/go/simplelog"
)

var benchCmd = &cobra.Command{
	Use:   "bench [flags] -- [bench-flags]",
	Short: "Run go bench",
	RunE: func(cmd *cobra.Command, args []string) error {
		benchCmd, err := goatTestWrapperCmd(args)
		if err != nil {
			return err
		}

		yaMakeCmd := exec.Command(
			"ya",
			"make", "-t", "--test-stdout",
			"-F", "*::Benchmark*",
		)
		yaMakeCmd.Env = append(os.Environ(), "TEST_COMMAND_WRAPPER="+benchCmd)
		yaMakeCmd.Stdout = os.Stdout
		yaMakeCmd.Stderr = os.Stderr

		simplelog.Debug("run", "cmd", strings.Join(yaMakeCmd.Args, " "))
		return yaMakeCmd.Run()
	},
}

func init() {
	RootCmd.AddCommand(benchCmd)
}

func goatTestWrapperCmd(args []string) (name string, resultErr error) {
	selfEx, err := os.Executable()
	if err != nil {
		resultErr = err
		return
	}

	name = fmt.Sprintf(
		"%s bench-wrapper --skip-version-check -- %s --run_go_test",
		selfEx,
		strings.Join(args, " "),
	)
	return
}
