package commands

import (
	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/tools/goat/internal/fixer"
)

var fixCmd = &cobra.Command{
	Use:   "fix [flags] [target]",
	Short: "Fix ya.make files of current project",
	RunE: func(_ *cobra.Command, args []string) error {
		target, err := parseTarget(args)
		if err != nil {
			return err
		}

		if err := fixer.YMake(target, fixer.YMakeOptions{Owners: fixOwners}); err != nil {
			return err
		}

		return nil
	},
}

var (
	fixOwners []string
)

func init() {
	flags := fixCmd.PersistentFlags()
	flags.StringSliceVar(&fixOwners, "add-owner", projectConfig.Fix.Owners, "add users or groups to list of owners")
	RootCmd.AddCommand(fixCmd)
}
