package commands

import (
	"fmt"
	"os"
	"os/exec"
	"path/filepath"
	"strings"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/tools/goat/internal/ya"
)

var lintCmd = &cobra.Command{
	Use:    "lint [flags] [target]",
	Short:  "Run golang linter",
	Hidden: true,
	Long:   `Deprecated wrapper for "ya make -tt --style".`,
	RunE: func(_ *cobra.Command, args []string) error {
		target, err := parseTarget(args)
		if err != nil {
			return err
		}

		absTarget, err := filepath.Abs(target)
		if err != nil {
			return xerrors.Errorf("current absolute path: %v", err)
		}

		goLintCmd := exec.Command(ya.Path(), "make", "-tt", "--style", absTarget)
		goLintCmd.Stdout = os.Stdout
		goLintCmd.Stderr = os.Stderr

		simplelog.Debug(fmt.Sprintf("run: %s", strings.Join(goLintCmd.Args, " ")))
		return goLintCmd.Run()
	},
}

var (
	lintRecommended bool
)

func init() {
	flags := lintCmd.PersistentFlags()
	flags.BoolVarP(&lintRecommended, "recommended", "r", lintRecommended, `Use "recommended" linter config`)

	RootCmd.AddCommand(lintCmd)
}
