package fixer

import (
	"fmt"
	"os"
	"os/exec"
	"strings"

	"a.yandex-team.ru/security/libs/go/simplelog"
	"a.yandex-team.ru/security/tools/goat/internal/ya"
)

type (
	YMakeOptions struct {
		Owners []string
	}
)

func YMake(target string, opts YMakeOptions) error {
	yaArgs := []string{
		"tool", "yo", "fix",
	}
	if len(opts.Owners) > 0 {
		yaArgs = append(yaArgs, "--add-owner", strings.Join(opts.Owners, " "))
	}
	yaArgs = append(yaArgs, target)

	yoCmd := exec.Command(ya.Path(), yaArgs...)
	yoCmd.Stdout = os.Stdout
	yoCmd.Stderr = os.Stderr

	simplelog.Debug(fmt.Sprintf("run: %s", strings.Join(yoCmd.Args, " ")))
	return yoCmd.Run()
}
