package formatter

import (
	"bytes"
	"fmt"
	"io/fs"
	"io/ioutil"
	"os"
	"strings"

	"a.yandex-team.ru/library/go/yoimports/pkg/imports"
	"a.yandex-team.ru/security/libs/go/simplelog"
)

func IsGoDirEnt(d fs.DirEntry) bool {
	name := d.Name()
	return !d.IsDir() && !strings.HasPrefix(name, ".") && strings.HasSuffix(name, ".go")
}

func IsGoFile(f os.FileInfo) bool {
	name := f.Name()
	return !f.IsDir() && !strings.HasPrefix(name, ".") && strings.HasSuffix(name, ".go")
}

func FormatFile(path string) error {
	simplelog.Debug("process file", "path", path)

	src, err := ioutil.ReadFile(path)
	if err != nil {
		return err
	}

	dst, err := imports.Process(src)
	if err != nil {
		return err
	}

	if !bytes.Equal(src, dst) {
		simplelog.Info(fmt.Sprintf("fix: %s", path))
		err = ioutil.WriteFile(path, dst, 0)
		if err != nil {
			return err
		}
	}

	return nil
}
