package project

import (
	"context"
	"os"
	"path/filepath"

	"github.com/heetch/confita"
	"github.com/heetch/confita/backend/file"

	"a.yandex-team.ru/security/libs/go/simplelog"
)

type Config struct {
	Fix struct {
		Owners    []string `toml:"owners" config:"owners"`
		NoIgnores bool     `toml:"no-ignores" config:"no-ignores"`
	} `toml:"fix" config:"fix"`
	Fmt struct {
		LaxImports bool `toml:"lax-imports" config:"lax-imports"`
	} `toml:"fmt" config:"fmt"`
}

func LoadConfig() (cfg Config) {
	if cfgPath := findConfig(); cfgPath != "" {
		simplelog.Debug("load project config", "path", cfgPath)

		loader := confita.NewLoader(
			file.NewBackend(cfgPath),
		)

		err := loader.Load(context.Background(), &cfg)
		if err != nil {
			simplelog.Error("failed to load project config", "err", err)
		}
	}

	return
}

func findConfig() (cfgPath string) {
	arcPath, err := filepath.Abs(".")
	if err != nil {
		simplelog.Error("failed to resolve current path", "err", err)
		return
	}

	current := filepath.Clean(arcPath)
	for {
		candidate := filepath.Join(current, ".goat.toml")
		if _, err := os.Stat(candidate); err == nil {
			return candidate
		}

		next := filepath.Dir(current)
		if next == current {
			return ""
		}

		current = next
	}
}
