package commands

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

func newLogger(childName string) log.Structured {
	lvl := log.InfoLevel
	if verbose {
		lvl = log.DebugLevel
	}

	zlog, err := zap.New(zap.JSONConfig(lvl))
	if err != nil {
		panic(fmt.Sprintf("failed to create logger: %s", err))
	}

	return log.With(zlog, log.String("child", childName)).Structured()
}
