package commands

import (
	"context"
	"fmt"
	"os"
	"time"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/security/tools/starter/pkg/starter"
)

var pingCmd = &cobra.Command{
	Use:          "ping",
	SilenceUsage: true,
	Short:        "ping child",
	RunE: func(cmd *cobra.Command, args []string) error {
		client, err := starter.NewClient(
			starter.WithChild(childName),
			starter.WithLogger(newLogger(childName)),
		)
		if err != nil {
			return xerrors.Errorf("failed to create starter client: %w", err)
		}

		ctx, cancel := context.WithTimeout(context.Background(), 2*time.Second)
		defer cancel()
		reply, err := client.Ping(ctx)
		if err != nil {
			return xerrors.Errorf("failed to ping child: %w", err)
		}

		if reply.Status == starter.ChildStatusStarted {
			fmt.Println("OK")
			return nil
		}

		fmt.Printf("child in unexpected status %s: %s", reply.Status.String(), reply.Reason)
		os.Exit(int(reply.Status) + 100)
		return nil
	},
}

func init() {
	rootCmd.AddCommand(pingCmd)
}
