package commands

import (
	"os"

	"github.com/spf13/cobra"
)

var rootCmd = &cobra.Command{
	Use:          "starter",
	SilenceUsage: true,
	Short:        "starter is a helper for starts processes in YP",
}

var (
	verbose   bool
	childName string
)

func Execute() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}

func init() {
	flags := rootCmd.PersistentFlags()
	flags.StringVar(&childName, "name", "root", "child name")
	flags.BoolVar(&verbose, "verbose", false, "be verbose")
}
