package commands

import (
	"context"
	"fmt"
	"time"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/security/tools/starter/pkg/starter"
)

var stopCmd = &cobra.Command{
	Use:          "stop",
	SilenceUsage: true,
	Short:        "stop child",
	RunE: func(cmd *cobra.Command, args []string) error {
		logger := newLogger(childName)
		client, err := starter.NewClient(
			starter.WithChild(childName),
			starter.WithLogger(logger),
		)
		if err != nil {
			return xerrors.Errorf("failed to create starter client: %w", err)
		}

		// first of all - let's stop out child
		{
			err := func() error {
				logger.Info("stopping")

				ctx, cancel := context.WithTimeout(context.Background(), 2*time.Minute)
				defer cancel()

				return client.Stop(ctx)
			}()

			if err != nil {
				return xerrors.Errorf("failed to stop child: %w", err)
			}
		}

		// and wait it if needed
		if stopWait {
			var done bool
			for !done {
				func() {
					logger.Info("wait termination")

					ctx, cancel := context.WithTimeout(context.Background(), 2*time.Second)
					defer cancel()

					_, err = client.Ping(ctx)
					if err != nil {
						done = true
					} else {
						time.Sleep(100 * time.Millisecond)
					}
				}()
			}
		}

		fmt.Println("child stopped")
		return nil
	},
}

var (
	stopWait bool
)

func init() {
	stopCmd.PersistentFlags().BoolVar(&stopWait, "wait", false, "wait termination")
	rootCmd.AddCommand(stopCmd)
}
