package logger

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

func NewLogger(opts ...Option) log.Structured {
	o := &options{
		encoding: "cli",
		logLevel: log.InfoLevel,
	}

	for _, opt := range opts {
		opt(o)
	}

	zlog, err := zap.New(zap.StandardConfig(o.encoding, o.logLevel))
	if err != nil {
		panic(fmt.Sprintf("failed to create logger: %s", err))
	}

	return zlog.Structured()
}
