package logger

import "a.yandex-team.ru/library/go/core/log"

type options struct {
	encoding string
	logLevel log.Level
}

type Option func(*options)

type Level = log.Level

const (
	TraceLevel = log.TraceLevel
	DebugLevel = log.DebugLevel
	InfoLevel  = log.InfoLevel
	WarnLevel  = log.WarnLevel
	ErrorLevel = log.ErrorLevel
	FatalLevel = log.FatalLevel
)

func WithEncoding(encoding string) Option {
	return func(o *options) {
		o.encoding = encoding
	}
}

func WithLogLevel(l Level) Option {
	return func(o *options) {
		o.logLevel = l
	}
}
