package server

import (
	"context"
	"fmt"

	"a.yandex-team.ru/security/tools/starter/pkg/starter/rpc"
)

func (s *Server) Ping(ctx context.Context, req *rpc.PingRequest) (*rpc.PingReply, error) {
	err := s.child.Ping()
	if err != nil {
		return &rpc.PingReply{
			Status: rpc.ChildStatus_CS_NOT_STARTED,
			Reason: err.Error(),
		}, nil
	}

	return &rpc.PingReply{
		Status: rpc.ChildStatus_CS_STARTED,
		Reason: fmt.Sprintf("child running, PID: %d", s.child.Status().PID),
	}, nil
}

func (s *Server) Stop(ctx context.Context, req *rpc.StopRequest) (*rpc.StopReply, error) {
	err := s.child.Stop()
	if err != nil {
		return nil, err
	}

	return &rpc.StopReply{}, nil
}
