package starter

import (
	"context"
	"net"
	"time"

	"google.golang.org/grpc"
)

const (
	dialTimeout = 200 * time.Millisecond
)

func NewConnection(address string, opts ...grpc.DialOption) (*grpc.ClientConn, error) {
	dialer := net.Dialer{
		Timeout: dialTimeout,
	}

	opts = append(
		opts,
		grpc.WithInsecure(),
		grpc.WithContextDialer(
			func(context.Context, string) (net.Conn, error) {
				return dialer.Dial("unix", address)
			},
		),
	)

	return grpc.Dial(
		"passthrough:///unix",
		opts...,
	)
}
