package starter

import (
	"google.golang.org/grpc"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/tools/starter/internal/uds"
)

type Option func(*Client)

func WithAddr(addr string) Option {
	return func(c *Client) {
		c.addr = addr
	}
}

func WithChild(child string) Option {
	return func(c *Client) {
		c.addr = uds.Addr(child)
	}
}

func WithLogger(logger log.Structured) Option {
	return func(c *Client) {
		c.l = logger
	}
}

func WithGrpcOption(opts ...grpc.DialOption) Option {
	return func(c *Client) {
		c.dialOpts = opts
	}
}
