package app

import (
	"net/http"
	"time"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/vt-proxy/internal/filereport"
	"a.yandex-team.ru/security/vt-proxy/internal/logger"
)

type (
	ReportResponse struct {
		CacheStatus   filereport.CacheStatus `json:"vt_cache,omitempty"`
		Found         bool                   `json:"vt_found"`
		Md5           string                 `json:"md5,omitempty"`
		Sha1          string                 `json:"sha1,omitempty"`
		Sha256        string                 `json:"sha256,omitempty"`
		Positives     int                    `json:"vt_detection_count"`
		DiffPositives int                    `json:"diff_detection_count,omitempty"`
		Total         int                    `json:"vt_total_count"`
		CreatedAt     *time.Time             `json:"created_at,omitempty"`
		UpdatedAt     *time.Time             `json:"updated_at,omitempty"`
		DiffUpdatedAt *time.Time             `json:"diff_updated_at,omitempty"`
		Scans         map[string]struct {
			Detected bool   `json:"detected"`
			Version  string `json:"version"`
			Result   string `json:"result"`
			Update   string `json:"update"`
		} `json:"vt_scans,omitempty"`
	}

	ReportOptions struct {
		Force bool `form:"force" json:"force"`
	}

	response struct {
		Ok     bool        `json:"ok"`
		Result interface{} `json:"result,omitempty"`
		Error  error       `json:"error,omitempty"`
	}
)

func returnErr(c echo.Context, err error) error {
	logger.Error("internal error", log.String("request_uri", c.Request().RequestURI), log.Error(err))

	return c.JSON(http.StatusInternalServerError, response{
		Ok:    false,
		Error: err,
	})
}

func returnOk(c echo.Context, result interface{}) error {
	return c.JSON(http.StatusOK, response{
		Ok:     true,
		Result: result,
	})
}
