package filereport

import (
	"encoding/json"

	"a.yandex-team.ru/security/vt-proxy/internal/unistat"
)

const (
	CacheStatusHotCache = iota
	CacheStatusCache
	CacheStatusVtNew
	CacheStatusVtRefresh
	CacheStatusVtChanged
)

type CacheStatus struct {
	Status int
}

func (c CacheStatus) String() string {
	switch c.Status {
	case CacheStatusHotCache:
		return "hot-cache"
	case CacheStatusCache:
		return "cache"
	case CacheStatusVtNew:
		return "vt-new"
	case CacheStatusVtRefresh:
		return "vt-refresh"
	case CacheStatusVtChanged:
		return "vt-changed"
	}
	return "unknown"
}

func (c CacheStatus) Stat(stat *unistat.Counter) {
	switch c.Status {
	case CacheStatusHotCache:
		stat.AddCacheHit()
	case CacheStatusCache:
		stat.AddCacheHit()
	case CacheStatusVtNew:
		stat.AddVtFetch()
		stat.AddVtNew()
	case CacheStatusVtRefresh:
		stat.AddVtFetch()
		stat.AddVtRefresh()
	}
}

func (c CacheStatus) MarshalJSON() ([]byte, error) {
	return json.Marshal(c.String())
}
