package logger

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

var (
	l = func() log.Logger {
		zlog, err := zap.New(zap.JSONConfig(log.InfoLevel))
		if err != nil {
			panic(fmt.Sprintf("failed to create logger: %s", err))
		}
		return zlog
	}()
)

func Logger() log.Logger {
	return l
}

// Trace logs at Trace log level using fields
func Trace(msg string, fields ...log.Field) {
	l.Trace(msg, fields...)
}

func Debug(msg string, fields ...log.Field) {
	l.Debug(msg, fields...)
}

func Info(msg string, fields ...log.Field) {
	l.Info(msg, fields...)
}

func Warn(msg string, fields ...log.Field) {
	l.Warn(msg, fields...)
}

func Error(msg string, fields ...log.Field) {
	l.Error(msg, fields...)
}

func Fatal(msg string, fields ...log.Field) {
	l.Fatal(msg, fields...)
}
