package models

import (
	"time"
)

type (
	Report struct {
		Found     bool      `json:"found"`
		Md5       string    `json:"md5"`
		Sha1      string    `json:"sha1"`
		Sha256    string    `json:"sha256"`
		Positives int       `json:"positives"`
		Total     int       `json:"total"`
		CreatedAt time.Time `json:"created_at"`
		UpdatedAt time.Time `json:"updated_at"`
		Scans     map[string]struct {
			Detected bool   `json:"detected"`
			Version  string `json:"version"`
			Result   string `json:"result"`
			Update   string `json:"update"`
		} `json:"scans,omitempty"`
	}
)
