package middleware

import (
	"log"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmtool"
)

func getUser(bb blackbox.Client, c echo.Context) *blackbox.User {
	sessid, err := c.Cookie("Session_id")
	if err != nil {
		return nil
	}

	rsp, err := bb.SessionID(
		c.Request().Context(),
		blackbox.SessionIDRequest{
			SessionID: sessid.Value,
			UserIP:    c.RealIP(),
			Host:      c.Request().Host,
		})

	if err != nil {
		log.Printf("failed to check user session: %s\n", err)
		return nil
	}

	return &rsp.User
}

func AuthMiddleware(acl map[string]bool) echo.MiddlewareFunc {
	tvmClient, err := tvmtool.NewDeployClient()
	if err != nil {
		// TODO: return err
		panic(err)
	}

	bb, err := httpbb.NewIntranet(httpbb.WithTVM(tvmClient))
	if err != nil {
		panic(err)
	}

	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(c echo.Context) error {
			user := getUser(bb, c)
			if user == nil {
				return c.JSON(403, "Go away")
			}
			if acl[user.Login] {
				return next(c)
			}
			return c.JSON(403, "Go away "+user.Login)
		}
	}
}
