package middleware

import (
	"log"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmtool"
)

type RespCheckSrv struct {
	DebugString   string      `json:"debug_string"`
	Dst           int         `json:"dst"`
	LoggingString string      `json:"logging_string"`
	Scopes        interface{} `json:"scopes"`
	Src           int         `json:"src"`
}

type TVMServices map[tvm.ClientID]string

type TVMOptions struct {
	Services TVMServices
}

// Middleware validates TVM ticket.
func TVMMiddleware(options TVMOptions) echo.MiddlewareFunc {
	services := options.Services
	tvmClient, err := tvmtool.NewDeployClient()
	if err != nil {
		// TODO: return err
		panic(err)
	}

	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(c echo.Context) error {
			r := c.Request()

			serviceTicket := r.Header.Get("X-Ya-Service-Ticket")
			if serviceTicket == "" {
				return c.JSON(403, "No TVM ticket,"+
					" add X-Ya-Service-Ticket Header")
			}

			ticketInfo, err := tvmClient.CheckServiceTicket(c.Request().Context(), serviceTicket)
			if err != nil {
				log.Printf("failed to check tvm ticket: %v\n", err)
			} else {
				if services[ticketInfo.SrcID] != "" {
					return next(c)
				}

				log.Printf("unknown TVM client: %s\n", ticketInfo.DbgInfo)
			}
			return c.JSON(403, "Tvm ticket error")
		}
	}
}
