package config

import (
	"sync"

	"a.yandex-team.ru/library/go/yandex/tvm"
)

type Config struct {
	Debug         bool            `json:"debug"`
	Port          string          `json:"port"`
	AllowedLogins []string        `json:"allowed-logins"`
	ACL           map[string]bool `json:"-"`
	TVMServices   map[int]string  `json:"tvm-services"`
	NodeEnv       string          `json:"-"`
	AppTVMId      tvm.ClientID
	AppTVMName    string
	aclLock       sync.RWMutex
}

func (c *Config) RefreshACL() {
	acl := map[string]bool{}
	for _, login := range c.AllowedLogins {
		acl[login] = true
	}

	c.aclLock.Lock()
	c.ACL = acl
	c.aclLock.Unlock()
}

func (c *Config) CheckACL(login string) bool {
	c.aclLock.RLock()
	_, validUser := c.ACL[login]
	c.aclLock.RUnlock()
	return validUser
}
