package dns

func ParseDNSZone(records []Record) *Tree {
	var aRecords = map[string][]string{}
	var aaaaRecords = map[string][]string{}
	var virtualHosts = map[string][]string{}
	var cnames = map[string]string{}

	for _, record := range records {
		switch record.Type {
		case "A":
			virtualHosts[record.Data] = append(virtualHosts[record.Data], record.Name)
			aRecords[record.Name] = append(aRecords[record.Name], record.Data)
		case "AAAA":
			virtualHosts[record.Data] = append(virtualHosts[record.Data], record.Name)
			aaaaRecords[record.Name] = append(aaaaRecords[record.Name], record.Data)
		case "CNAME":
			cnames[record.Name] = record.Data
		default:
			//logger.L.Warn("unknown dns record type", log.String("type", record.Type))
		}
	}

	for c, r := range cnames {
		i := 0
		deepCname := 4
		var virtualCnames []string

		for i < deepCname {
			aRecord := aRecords[r]
			aaaaRecord := aaaaRecords[r]

			if aRecord == nil && aaaaRecord == nil {
				virtualCnames = append(virtualCnames, c)
				// virtualCnames = append(virtualCnames, r)
				if cnames[r] != "" {
					z := r
					c = z
					r = cnames[z]
				}
				i = i + 1
				continue
			}

			for _, ip := range aRecord {
				virtualHosts[ip] = append(virtualHosts[ip], c)

				if virtualCnames != nil {
					virtualHosts[ip] = append(virtualHosts[ip], virtualCnames...)
				}
			}

			for _, ip := range aaaaRecord {
				virtualHosts[ip] = append(virtualHosts[ip], c)

				if virtualCnames != nil {
					virtualHosts[ip] = append(virtualHosts[ip], virtualCnames...)
				}
			}
			i = deepCname
		}
	}

	return NewTree(virtualHosts)
}
