'use strict';

$(document).ready(() => {
    function getIssues(filterBy, filterWith) {
        return $(`.issue[data-issue-${filterBy}="${filterWith}"]`);
    }

    function recalculateBadges() {
        $('.filter-badge').each((i, e) => {
            let elem = $(e);
            let issues = getIssues(e.dataset.filterBy, e.dataset.filterWith).not('.d-none').length;
            elem.text(issues);
        });
    }

    $(document).on('change', '.filter-item', function () {
        if (this.checked) {
            getIssues(this.dataset.filterBy, this.dataset.filterWith).removeClass('d-none');
        } else {
            getIssues(this.dataset.filterBy, this.dataset.filterWith).addClass('d-none');
        }
        recalculateBadges();
    });

    recalculateBadges();
});