package main

import (
	"fmt"
	"os"

	"google.golang.org/protobuf/proto"

	"a.yandex-team.ru/security/xray/internal/boxer"
)

func fatalf(format string, a ...interface{}) {
	_, _ = fmt.Fprintf(os.Stderr, format, a...)
	os.Exit(1)
}

func main() {
	info, err := boxer.CollectInfo()
	if err != nil {
		fatalf("%s\n", err)
		return
	}

	if info == nil {
		// that's fine
		return
	}

	out, err := proto.Marshal(info)
	if err != nil {
		fatalf("marshal failed: %s\n", err)
		return
	}

	_, _ = os.Stdout.Write(out)
}
