package abc

import (
	"time"

	"a.yandex-team.ru/library/go/core/log"
)

type Option func(client *Client)

func WithRetries(retries int) Option {
	return func(client *Client) {
		client.httpc.SetRetryCount(retries)
	}
}

func WithTimeout(timeout time.Duration) Option {
	return func(client *Client) {
		client.httpc.SetTimeout(timeout)
	}
}

func WithHostURI(hostURI string) Option {
	return func(client *Client) {
		client.httpc.SetBaseURL(hostURI)
	}
}

func WithLogger(logger log.Structured) Option {
	return func(client *Client) {
		client.logger = logger
		client.httpc.SetDebug(true)
		client.httpc.SetLogger(logger.Fmt())
	}
}

func WithDebug(debug bool) Option {
	return func(client *Client) {
		client.httpc.SetDebug(debug)
	}
}
