package cli

import (
	"context"
	"fmt"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/xray/pkg/xray"
)

var pingCmd = &cobra.Command{
	Use: "ping",
	RunE: func(_ *cobra.Command, args []string) error {
		client, err := xray.NewClient(clientOpts()...)
		if err != nil {
			return fmt.Errorf("failed create client: %w", err)
		}

		defer closeClient(client)
		if err = client.Ping(context.Background()); err != nil {
			return err
		}

		fmt.Println("OK")
		return nil
	},
}

func init() {
	RootCmd.AddCommand(pingCmd)
}
