package dbmodels

import (
	"time"
)

type (
	ScheduleStageData struct {
		CreatedAt     time.Time
		StageID       string
		StageUUID     string
		AnalyzeID     string
		Description   string
		StageRevision uint32
		Status        Status
	}

	ScheduleLatestStageData struct {
		CreatedAt     time.Time
		StageID       string
		StageUUID     string
		StageRevision uint32
		AnalyzeID     string
		Description   string
		Status        Status
		Force         bool
		Scheduler     func() (analyzeID string, err error)
	}

	UpdateAnalyzeData struct {
		UpdatedAt         time.Time
		AnalyzeID         string
		StageUUID         string
		ResultPath        string
		LogPath           string
		StatusDescription string
		StageRevision     uint32
		Status            Status
		Overview          StageOverview
	}
)
