package dbmodels

import (
	"time"

	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

type Status = xrayrpc.AnalysisStatusKind

type StageInfo struct {
	ID       string
	UUID     string
	Revision uint32
}

type StageStatus struct {
	StageInfo
	UpdatedAt time.Time
	Status    Status
	Overview  StageOverview
}

type StageAnalysis struct {
	ID                string
	UpdatedAt         time.Time
	ResultPath        string
	LogPath           string
	Status            Status
	StatusDescription string
	Overview          StageOverview
}

type StageIssuesCounter struct {
	Unknown uint32 `json:"u,omitempty"`
	Info    uint32 `json:"i,omitempty"`
	Low     uint32 `json:"l,omitempty"`
	Medium  uint32 `json:"m,omitempty"`
	High    uint32 `json:"h,omitempty"`
}

type StageOverview struct {
	Issues   StageIssuesCounter `json:"i"`
	Warnings uint32             `json:"w"`
}
