package fsutil

import (
	"fmt"
	"os"
)

func CreateDir(path string) error {
	if stat, err := os.Stat(path); err == nil {
		if stat.IsDir() {
			return nil
		}
		return fmt.Errorf("%s is not a directory", path)
	}
	return os.MkdirAll(path, 0755)
}
