package vuln

import (
	"fmt"
	"sync"

	"a.yandex-team.ru/security/yadi/libs/versionarium"
)

var (
	versOnce  sync.Once
	vulnRange versionarium.VersionRange
)

func IsVulnerableVersion(ver string) bool {
	curVer, err := versionarium.NewVersion("java", ver)
	if err != nil {
		return false
	}

	versOnce.Do(func() {
		var err error
		vulnRange, err = versionarium.NewRange("java", "[2.0.0, 2.15.0)")
		if err != nil {
			panic(fmt.Sprintf("can't parse vulns range: %v", err))
		}
	})

	return vulnRange.Check(curVer)
}
