package logutil

import (
	"gopkg.in/yaml.v2"

	"a.yandex-team.ru/library/go/core/log"
)

var _ yaml.Unmarshaler = (*Level)(nil)
var _ yaml.Marshaler = (*Level)(nil)

type Level struct {
	log.Level
}

func (k Level) MarshalYAML() (interface{}, error) {
	return k.String(), nil
}

func (k *Level) UnmarshalYAML(unmarshal func(interface{}) error) error {
	var v string
	if err := unmarshal(&v); err != nil {
		return err
	}

	lvl, err := log.ParseLevel(v)
	k.Level = lvl
	return err
}
