package queue

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"

	"a.yandex-team.ru/library/go/yandex/awstvm"
	"a.yandex-team.ru/library/go/yandex/tvm"
)

type Option func(q *aws.Config) error

func WithAuthOAuth(accessKeyID, token string) Option {
	return func(q *aws.Config) error {
		q.Credentials = credentials.NewStaticCredentials(
			accessKeyID,
			"unused",
			token,
		)
		return nil
	}
}

func WithAuthTVM(accessKeyID string, tvmClient tvm.Client) Option {
	return func(q *aws.Config) error {
		cred, err := awstvm.NewSqsCredentials(tvmClient, accessKeyID)
		if err != nil {
			return fmt.Errorf("failed to create SQS TVM credentials: %w", err)
		}
		q.Credentials = cred
		return nil
	}
}

func WithMaxRetries(retries int) Option {
	return func(q *aws.Config) error {
		q.MaxRetries = &retries
		return nil
	}
}
