package auth

import (
	"context"

	"a.yandex-team.ru/library/go/yandex/blackbox"
)

type ctxKey struct{}

type Info struct {
	UserID    blackbox.ID
	UserLogin string
	IsAdmin   bool
	IsReader  bool
}

var infoKey = &ctxKey{}

func WithAuthInfo(ctx context.Context, i *Info) context.Context {
	return context.WithValue(ctx, infoKey, i)
}

func ContextAuthInfo(ctx context.Context) *Info {
	i, ok := ctx.Value(infoKey).(*Info)
	if ok {
		return i
	}
	return nil
}
