package services

import (
	"context"

	grpcAuth "github.com/grpc-ecosystem/go-grpc-middleware/auth"
	"google.golang.org/protobuf/types/known/emptypb"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/xray/internal/servers/grpc/infra"
	"a.yandex-team.ru/security/xray/pkg/xrayrpc"
)

var (
	_ xrayrpc.CommonServiceServer      = (*CommonService)(nil)
	_ grpcAuth.ServiceAuthFuncOverride = (*CommonService)(nil)

	pingReply = &emptypb.Empty{}
)

type CommonService struct {
	*infra.Infra
}

// No auth required
func (s *CommonService) AuthFuncOverride(ctx context.Context, _ string) (context.Context, error) {
	return ctx, nil
}

func (s *CommonService) Ping(ctx context.Context, _ *emptypb.Empty) (*emptypb.Empty, error) {
	if _, err := s.TVM.GetStatus(ctx); err != nil {
		s.Logger.Error("failed to ping tvm client", log.Error(err))
		return nil, err
	}

	return pingReply, nil
}
